/*
 * Decompiled with CFR 0.152.
 */
package de.winniepat.winnieclient.backend;

import de.craftsblock.craftscore.json.Json;
import de.craftsblock.craftscore.json.JsonParser;
import de.winniepat.winnieclient.backend.ApiConstants;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.class_310;
import net.minecraft.class_320;

public class LoginChallenge
implements ApiConstants {
    private final HttpClient client;
    private String token;
    private boolean loggedIn = false;

    public LoginChallenge(HttpClient client) {
        this.client = client;
    }

    public void verifyLoginOrLogin() {
        if (this.isLoggedIn()) {
            return;
        }
        if (this.hasLoginToken()) {
            this.verifyMinecraftLicense();
            if (this.verifyLogin()) {
                return;
            }
            this.logout();
        }
        Json credentials = this.verifyMinecraftLicense(true);
        this.login(credentials);
    }

    public boolean verifyLogin() {
        try {
            HttpRequest request = HttpRequest.newBuilder(this.buildApiUri("/account/session/check")).setHeader("Authorization", "Bearer %s".formatted(this.token)).GET().build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            Json json = JsonParser.parse((String)response.body());
            return json.contains("status") && json.getInt("status") == 200;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not verify login", e);
        }
    }

    public void login(Json credentials) {
        credentials.moveTo("id", "login.id");
        credentials.moveTo("type", "login.type");
        credentials.moveTo("secret", "login.token");
        try {
            HttpRequest.BodyPublisher body = HttpRequest.BodyPublishers.ofString(credentials.toString());
            HttpRequest request = HttpRequest.newBuilder(this.buildApiUri("/account/session/login")).setHeader("Content-Type", "application/json").POST(body).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            Json json = JsonParser.parse((String)response.body());
            if (json.getInt("status") != 200) {
                this.loggedIn = false;
                return;
            }
            this.token = json.getString("token");
            this.loggedIn = true;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not log in", e);
        }
    }

    public void logout() {
        try {
            HttpRequest request = HttpRequest.newBuilder(this.buildApiUri("/account/session/logout")).setHeader("Authorization", "Bearer %s".formatted(this.token)).DELETE().build();
            this.client.send(request, HttpResponse.BodyHandlers.discarding());
            this.loggedIn = false;
            this.token = null;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not log out", e);
        }
    }

    public void verifyMinecraftLicense() {
        this.verifyMinecraftLicense(false);
    }

    private Json verifyMinecraftLicense(boolean forLogin) {
        Json tokenResponse = this.requestMinecraftChallenge();
        if (tokenResponse.getInt("status") != 200) {
            throw new IllegalStateException("Could not generate token: %s (%s)".formatted(tokenResponse.getString("message"), tokenResponse));
        }
        String token = tokenResponse.getString("token");
        int joinChallengeResponse = this.performMinecraftChallenge(token);
        if (joinChallengeResponse != 204) {
            throw new IllegalStateException("Could not verify session");
        }
        Json challengeResponse = this.completeMinecraftChallenge(token, forLogin);
        int challengeResposeCode = challengeResponse.getInt("status");
        if (challengeResposeCode != 200) {
            throw new IllegalStateException("Could not verify session");
        }
        System.out.println("Session is verified!");
        return challengeResponse.getJson("login");
    }

    private Json requestMinecraftChallenge() {
        try {
            HttpRequest request = HttpRequest.newBuilder(this.buildApiUri("/minecraft/session/challenge/create")).GET().build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            return JsonParser.parse((String)response.body());
        }
        catch (IOException | InterruptedException e) {
            System.err.println("ERROR: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Could not request minecraft challenge", e);
        }
    }

    private int performMinecraftChallenge(String token) {
        try {
            class_320 session = class_310.method_1551().method_1548();
            String accessToken = session.method_1674();
            String profileID = Optional.ofNullable(session.method_44717()).orElseThrow().toString().replace("-", "");
            HttpRequest.BodyPublisher body = HttpRequest.BodyPublishers.ofString(Json.empty().set("accessToken", (Object)accessToken).set("selectedProfile", (Object)profileID).set("serverId", (Object)token).toString());
            HttpRequest request = HttpRequest.newBuilder(URI.create("https://sessionserver.mojang.com/session/minecraft/join")).POST(body).setHeader("Content-Type", "application/json").build();
            HttpResponse<Void> response = this.client.send(request, HttpResponse.BodyHandlers.discarding());
            return response.statusCode();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not perform minecraft challenge", e);
        }
    }

    private Json completeMinecraftChallenge(String token, boolean forLogin) {
        try {
            class_320 session = class_310.method_1551().method_1548();
            HttpRequest.BodyPublisher body = HttpRequest.BodyPublishers.ofString(Json.empty().set("name", (Object)session.method_1676()).set("token", (Object)token).toString());
            HttpRequest request = HttpRequest.newBuilder(this.buildApiUri("/minecraft/session/challenge/complete%s".formatted(forLogin ? "" : "?flag=verify"))).POST(body).setHeader("Content-Type", "application/json").build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            return JsonParser.parse((String)response.body());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not complete minecraft challenge", e);
        }
    }

    public boolean hasLoginToken() {
        return this.token != null;
    }

    public boolean isLoggedIn() {
        return this.loggedIn && this.hasLoginToken();
    }
}

