/*
 * Decompiled with CFR 0.152.
 */
package de.winniepat.winnieclient.utils.gui;

import org.apache.commons.lang3.StringUtils;
import org.joml.Vector3f;

public class Color {
    private int r;
    private int g;
    private int b;
    private int alpha = 255;
    private float hue;
    private float saturation;
    private float luminance;

    public Color(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.HSVFromRGB(r, g, b);
    }

    public Color(int r, int g, int b, int alpha) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.HSVFromRGB(r, g, b);
        this.alpha = alpha;
    }

    public Color(float r, float g, float b, float alpha) {
        this.r = (int)(r * 255.0f);
        this.g = (int)(g * 255.0f);
        this.b = (int)(b * 255.0f);
        this.alpha = (int)(alpha * 255.0f);
    }

    public Color getAsSolid() {
        return new Color(this.r, this.g, this.b, 255);
    }

    public static Color interpolate(Color color1, Color color2, float factor) {
        int r = (int)((float)color1.r + (float)(color2.r - color1.r) * factor);
        int g = (int)((float)color1.g + (float)(color2.g - color1.g) * factor);
        int b = (int)((float)color1.b + (float)(color2.b - color1.b) * factor);
        int alpha = (int)((float)color1.alpha + (float)(color2.alpha - color1.alpha) * factor);
        return new Color(r, g, b, alpha);
    }

    private void HSVFromRGB(int r, int g, int b) {
        float cMin;
        float rPrime = (float)r / 255.0f;
        float gPrime = (float)g / 255.0f;
        float bPrime = (float)b / 255.0f;
        float cMax = Math.max(rPrime, Math.max(gPrime, bPrime));
        float delta = cMax - (cMin = Math.min(rPrime, Math.min(gPrime, bPrime)));
        if (delta == 0.0f) {
            this.hue = 0.0f;
        } else if (cMax == rPrime) {
            this.hue = 60.0f * ((gPrime - bPrime) / delta % 6.0f);
        } else if (cMax == gPrime) {
            this.hue = 60.0f * ((bPrime - rPrime) / delta + 2.0f);
        } else if (cMax == bPrime) {
            this.hue = 60.0f * ((rPrime - gPrime) / delta + 2.0f);
        }
        this.saturation = cMax == 0.0f ? 0.0f : delta / cMax;
        this.luminance = cMax;
    }

    public Color(float hue, float saturation, float luminance) {
        this.setHSV(hue, saturation, luminance);
    }

    public float getHue() {
        return this.hue;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getLuminance() {
        return this.luminance;
    }

    public void setHSV(float hue, float saturation, float luminance) {
        this.hue = hue;
        this.saturation = saturation;
        this.luminance = luminance;
        Color vec = Color.hsv2rgb(hue, saturation, luminance);
        if (vec != null) {
            this.r = vec.r;
            this.g = vec.g;
            this.b = vec.b;
        }
    }

    public void setHue(float hue) {
        this.hue = hue;
        Color vec = Color.hsv2rgb(this.hue, this.saturation, this.luminance);
        if (vec != null) {
            this.r = vec.r;
            this.g = vec.g;
            this.b = vec.b;
        }
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
        Color vec = Color.hsv2rgb(this.hue, this.saturation, this.luminance);
        if (vec != null) {
            this.r = vec.r;
            this.g = vec.g;
            this.b = vec.b;
        }
    }

    public void setLuminance(float luminance) {
        this.luminance = luminance;
        Color vec = Color.hsv2rgb(this.hue, this.saturation, this.luminance);
        if (vec != null) {
            this.r = vec.r;
            this.g = vec.g;
            this.b = vec.b;
        }
    }

    public void setRGB(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public void setRGBA(int r, int g, int b, int alpha) {
        this.r = r;
        this.g = b;
        this.b = b;
        this.alpha = alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public String getColorAsString() {
        String rs = Integer.toString(this.r);
        String gs = Integer.toString(this.g);
        String bs = Integer.toString(this.b);
        return rs + gs + bs;
    }

    public int getColorAsInt() {
        int Alpha = this.alpha << 24 & 0xFF000000;
        int R = this.r << 16 & 0xFF0000;
        int G = this.g << 8 & 0xFF00;
        int B = this.b & 0xFF;
        return Alpha | R | G | B;
    }

    public String getColorAsHex() {
        return String.format("#%06X", this.getColorAsInt());
    }

    public float getRed() {
        return (float)this.r / 255.0f;
    }

    public float getGreen() {
        return (float)this.g / 255.0f;
    }

    public float getBlue() {
        return (float)this.b / 255.0f;
    }

    public float getAlpha() {
        return (float)this.alpha / 255.0f;
    }

    public Color add(Color color) {
        return new Color(this.r + color.r, this.g + color.g, this.b + color.b);
    }

    public Color add(float r, float g, float b) {
        return new Color((int)Math.min(255.0f, (float)this.r + r), (int)Math.min(255.0f, (float)this.g + g), (int)Math.min(255.0f, (float)this.b + b));
    }

    public static String rgbToString(int r, int g, int b) {
        String rs = Integer.toString(r);
        String gs = Integer.toString(g);
        String bs = Integer.toString(b);
        return rs + gs + bs;
    }

    public static int rgbToInt(int r, int g, int b) {
        String rs = Integer.toString(r);
        String gs = Integer.toString(g);
        String bs = Integer.toString(b);
        return Integer.parseInt(rs + gs + bs);
    }

    public static int convertRGBToHex(int r, int g, int b) {
        String strr = StringUtils.leftPad((String)Integer.toHexString(r), (int)2, (char)'0');
        String strg = StringUtils.leftPad((String)Integer.toHexString(g), (int)2, (char)'0');
        String strb = StringUtils.leftPad((String)Integer.toHexString(b), (int)2, (char)'0');
        String string = strr + strg + strb;
        return Integer.parseInt(string, 16);
    }

    public static Color convertHextoRGB(String hexColor) {
        if ((hexColor = hexColor.replace("#", "")).length() == 6) {
            int r = Integer.valueOf(hexColor.substring(0, 2), 16);
            int g = Integer.valueOf(hexColor.substring(2, 4), 16);
            int b = Integer.valueOf(hexColor.substring(4, 6), 16);
            return new Color(r, g, b);
        }
        if (hexColor.length() == 8) {
            int alpha = Integer.valueOf(hexColor.substring(0, 2), 16);
            int r = Integer.valueOf(hexColor.substring(2, 4), 16);
            int g = Integer.valueOf(hexColor.substring(4, 6), 16);
            int b = Integer.valueOf(hexColor.substring(6, 8), 16);
            return new Color(r, g, b, alpha);
        }
        throw new IllegalArgumentException("Invalid hex color format. Expected 6 or 8 characters.");
    }

    public static Color hsv2rgb(float hue, float saturation, float luminance) {
        float h = hue / 60.0f;
        float chroma = luminance * saturation;
        float x = chroma * (1.0f - Math.abs(h % 2.0f - 1.0f));
        Object rgbVec = h >= 0.0f && h <= 1.0f ? new Vector3f(chroma, x, 0.0f) : (h >= 1.0f && h <= 2.0f ? new Vector3f(x, chroma, 0.0f) : (h >= 2.0f && h <= 3.0f ? new Vector3f(0.0f, chroma, x) : (h >= 3.0f && h <= 4.0f ? new Vector3f(0.0f, x, chroma) : (h >= 4.0f && h <= 5.0f ? new Vector3f(x, 0.0f, chroma) : (h >= 5.0f && h <= 6.0f ? new Vector3f(chroma, 0.0f, x) : null)))));
        if (rgbVec != null) {
            float m = luminance - chroma;
            return new Color((int)(255.0f * (rgbVec.x + m)), (int)(255.0f * (rgbVec.y + m)), (int)(255.0f * (rgbVec.z + m)));
        }
        return null;
    }
}

