/*
 * Decompiled with CFR 0.152.
 */
package de.winniepat.winnieclient.utils.gui;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class Rectangle {
    public static final Rectangle INFINITE = new Rectangle(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY));
    private Float x = null;
    private Float y = null;
    private Float width = null;
    private Float height = null;

    public Rectangle() {
    }

    public Rectangle(Float x, Float y, Float width, Float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(Rectangle rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    @Nullable
    public Float getX() {
        return this.x;
    }

    @Nullable
    public Float getY() {
        return this.y;
    }

    @Nullable
    public Float getWidth() {
        return this.width;
    }

    @Nullable
    public Float getHeight() {
        return this.height;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Rectangle otherRect = (Rectangle)other;
        if (!Objects.equals(this.x, otherRect.x)) {
            return false;
        }
        if (!Objects.equals(this.y, otherRect.y)) {
            return false;
        }
        if (!Objects.equals(this.width, otherRect.width)) {
            return false;
        }
        return Objects.equals(this.height, otherRect.height);
    }

    public boolean intersects(Rectangle rectangle) {
        return Math.abs(this.x.floatValue() - rectangle.x.floatValue()) * 2.0f < this.width.floatValue() + rectangle.width.floatValue() && Math.abs(this.y.floatValue() - rectangle.y.floatValue()) * 2.0f < this.height.floatValue() + rectangle.height.floatValue();
    }

    public boolean intersects(float x, float y) {
        float x2 = this.x.floatValue() + this.width.floatValue();
        float y2 = this.y.floatValue() + this.height.floatValue();
        return x >= this.x.floatValue() && x <= x2 && y >= this.y.floatValue() && y <= y2;
    }

    public void setX(Float x) {
        this.x = x;
    }

    public void setY(Float y) {
        this.y = y;
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    public void setHeight(Float height) {
        this.height = height;
    }

    public boolean isDrawable() {
        return this.x != null && this.y != null && this.width != null && this.height != null;
    }
}

